#!/bin/bash
#
# This script is common to all game command files; game name in $1 please.

game=$1;
if [ "$game" != "Adventure" ] && [ "$game" != "Qork" ]; then
    echo "Usage: commandCommon.sh Adventure|Qork"
    exit 1
fi

printf '\e[8;40;100t'

if [ `uname` = "Darwin" ]; then
    (cd bin; ln -fs perl5.30.0-static perl) # macOS
else
    (cd bin; ln -fs /usr/bin/perl perl) # Linux
fi

./play-text-adventure-games -game $game -manage-game-save-states

if [ `uname` = "Darwin" ]; then
    osascript -e 'tell application "Terminal" to close first window' & exit
fi
